/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define(['uiComponent', 'Magento_Customer/js/customer-data'], function (
  Component,
  customerData
) {
  'use strict'

  var countryData = customerData.get('directory-data')

  return Component.extend({
    defaults: {
      template: 'Afd_Pce/shipping-information/address-renderer/default'
    },

    initObservable: function () {
      this._super()
      return this
    },

    /**
     * @param {*} countryId
     * @return {String}
     */
    getCountryName: function (countryId) {
      return countryData()[countryId] != undefined
        ? countryData()[countryId].name
        : ''
    }
  })
})
