/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */

define([
  'jquery',
  'ko',
  'Magento_Checkout/js/view/shipping-address/address-renderer/default', // original component extended by afd
  'Magento_Checkout/js/action/select-shipping-address',
  'Magento_Checkout/js/model/quote',
  'Magento_Checkout/js/model/shipping-address/form-popup-state',
  'Magento_Checkout/js/checkout-data',
  'Magento_Customer/js/customer-data'
], function (
  $,
  ko,
  Component,
  selectShippingAddressAction,
  quote,
  formPopUpState,
  checkoutData,
  customerData
) {
  'use strict'

  var countryData = customerData.get('directory-data')

  return Component.extend({
    defaults: {
      template: 'Afd_Pce/shipping-address/address-renderer/default'
    },

    /** @inheritdoc */
    initObservable: function () {
      this._super()
      this.isSelected = ko.computed(function () {
        var isSelected = false,
          shippingAddress = quote.shippingAddress()

        if (shippingAddress) {
          isSelected = shippingAddress.getKey() == this.address().getKey()
        }

        return isSelected
      }, this)

      return this
    },

    /**symotion-prefix)
     * @param {String} countryId
     * @return {String}
     */
    getCountryName: function (countryId) {
      return countryData()[countryId] != undefined
        ? countryData()[countryId].name
        : ''
    },

    /** Set selected customer shipping address  */
    selectAddress: function () {
      selectShippingAddressAction(this.address())
      checkoutData.setSelectedShippingAddress(this.address().getKey())
    },

    /**
     * Edit address.
     */
    editAddress: function () {
      formPopUpState.isVisible(true)
      this.showPopup()
    },

    /**
     * Show popup.
     */
    showPopup: function () {
      $('[data-open-modal="opc-new-shipping-address"]').trigger('click')
    }
  })
})
